<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:n1="urn:hl7-org:v3" xmlns:n2="urn:hl7-org:v3/meta/voc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<!-- CDA document -->
    <xsl:template match="/">
        <html>
            <head />
            <body>            
				<xsl:apply-templates select="n1:ClinicalDocument"/>            
            </body>
        </html>
    </xsl:template>
    
<!-- Document title -->    
<xsl:template match="n1:ClinicalDocument/n1:title">
<h3>
<xsl:value-of select="."></xsl:value-of>
</h3>
<br />
</xsl:template>

<!-- StructuredBody -->
<xsl:template match="n1:component/n1:StructuredBody">
	<xsl:apply-templates/>
</xsl:template>

<!-- Component  -->
<xsl:template match="n1:component/n1:section">
	<xsl:apply-templates select="n1:text"/>
	<xsl:apply-templates select="n1:title"/>
	<ul>
	<xsl:apply-templates select="n1:component2/n1:section"/>
	</ul>
</xsl:template>

<!--  Section -->
<xsl:template match="n1:component2/n1:section">			
	<xsl:apply-templates select="n1:text"/>
	<xsl:apply-templates select="n1:title"/>
	<br />
	<xsl:for-each select="n1:component2/n1:section">
	<ul>
	<xsl:apply-templates select="n1:title"/>
		<ul>
			<xsl:apply-templates select="n1:text"/>
		</ul>
	</ul>
	</xsl:for-each>
	</xsl:template>

<!-- Title -->
<xsl:template match="n1:title">
	<span style="font-weight:bold">	
	<xsl:value-of select="."></xsl:value-of>
	</span>
</xsl:template>

<!-- Text -->
<xsl:template match="n1:text">		
	<xsl:apply-templates />	
</xsl:template>

<!-- paragraph -->
<xsl:template match="n1:paragraph">
	<xsl:apply-templates/>
	<br/>
</xsl:template>
</xsl:stylesheet>